<?php if ( ! defined( 'ABSPATH' ) ) {
	exit;}
/**
 *   detect the origin of an email
 **/
class Haet_Sender_Plugin_WP_Support_Plus extends Haet_Sender_Plugin {
	public function __construct( $mail ) {
		$advanced_settings = get_option( 'wpsp_advanced_settings' );
		$ticket_subject   = '[' . __( $advanced_settings['ticket_label_alice'][1], 'wp-support-plus-responsive-ticket-system' ) . ' ' . $advanced_settings['wpsp_ticket_id_prefix'];

		if ( strpos( $mail['subject'], $ticket_subject ) === false ) {
			throw new Haet_Different_Plugin_Exception();
		}
	}



	/**
	 *   modify_content()
	 *   mofify the email content before applying the template
	 **/
	public function modify_content( $content ) {
		return $content;
	}

	/**
	 *   modify_template()
	 *   mofify the email template before the content is added
	 **/
	public function modify_template( $template ) {
		return $template;
	}

	/**
	 *   modify_styled_mail()
	 *   mofify the email body after the content has been added to the template
	 **/
	public function modify_styled_mail( $message ) {
		return $message;
	}

}
