<?php

  /**
   * Main renderer for the Review Banner
   *
   * @category Child Plugin
   * @author iClyde <kontakt@iclyde.pl>
   */

  // Namespace
  namespace Inisev\Subs;

  // Disallow direct access
  if (!defined('ABSPATH')) exit;

?>

<section class="nri-nice-review-wrapper" id="nri-slug-wrapper" data-slug="<?php echo esc_html($this->slug); ?>">
  <div class="nri-nice-review nri-CDP" id="nri-sub-wrapper">
    <img src="<?php $this->_asset('imgs/background-pattern.svg'); ?>" alt="Background with stars" class="nri-background-pattern">
    <img src="<?php $this->_asset('imgs/BM-background.svg'); ?>" alt="Background Image" class="nri-BM-background">
    <div class="nri-main-image-wrapper">
      <div class="nri-main-image-content">
        <img src="<?php $this->_asset('imgs/main-image.svg'); ?>" alt="Images top" class="nri-main-image">
        <svg class="nri-main-image-part-1" width="20" height="21" viewBox="0 0 20 21" fill="none" xmlns="http://www.w3.org/2000/svg">
          <path fill-rule="evenodd" clip-rule="evenodd" d="M0.16333 20.7604V0.976166L19.9476 10.8713L0.16333 20.7604ZM3.9547 7.10886V14.6277L11.4697 10.8713L3.9547 7.10886Z" fill="#6BB4A7"/>
        </svg>
        <img src="<?php $this->_asset('imgs/main-image-part-2.svg'); ?>" alt="Images middle" class="nri-main-image-part-2">
        <svg class="nri-main-image-part-3" width="32" height="12" viewBox="0 0 32 12" fill="none" xmlns="http://www.w3.org/2000/svg">
          <path fill-rule="evenodd" clip-rule="evenodd" d="M7.05762 11.0941L0.098938 4.57857L2.51846 2.03343L7.05821 6.28666L12.8091 0.902252L18.5583 6.28666L24.3115 0.902252L31.2741 7.41783L28.8552 9.96297L24.3115 5.70974L18.5578 11.0941L12.8086 5.70974L7.05762 11.0941Z" fill="#6BB4A7"/>
        </svg>
        <img src="<?php $this->_asset('imgs/main-image-part-4.svg'); ?>" alt="Images end" class="nri-main-image-part-4">
      </div>
    </div>
    <div class="nri-content">
      <div class="nri-text">
        <p>You’ve been using the <a href="<?php echo $this->plugin_menu_url; ?>"><?php echo $this->name; ?></a> plugin for over <?php echo $this->days; ?> days<?php echo (($this->debug === true)?' ('.$this->minutes.' minutes)':''); ?> now – entirely <b>for FREE :)</b></p>
        <p>Don’t worry, we’re not asking you to upgrade to premium.<br class="visible-max-1300"> But maybe you can give us a nice review (if you like it)? We put a lot of effort into the free plugin, and made it feature-rich. It would motivate us a lot! Is that fair?</p>
      </div>
      <div class="nri-options-section">
        <a href="<?php echo $this->review_url; ?>" target="_blank" class="nri-leave-review-link nri-dismiss">
          <div class="nri-option-1">
            <button class="nri-round-button">Yes, that's fair!</button>
            <svg width="185" height="34">
              <path d="M 0 0 L 185 0 L 165 17 L 185 34 L 0 34 Z" />
              <text x="85" y="19" fill="#FFFFFF" text-anchor="middle" alignment-baseline="middle">
                Yes, that's fair!
              </text>
            </svg>
            <span>Let me give a nice review</span>
          </div>
        </a>
        <div class="nri-option-2">
          <button class="nri-remind">Ask me later</button>
        </div>
        <div class="nri-option-3">
          <button class="nri-dismiss">I already did</button>
        </div>
        <div class="nri-option-4">
          <button class="nri-dismiss">I'm just taking, not giving</button>
        </div>
      </div>
    </div>
  </div>
</section>
