<?php

namespace Analyst\Contracts;

use Analyst\ApiResponse;

interface RequestContract
{
	/**
	 * Cast request data to array
	 *
	 * @return array
	 */
	public function toArray();

	/**
	 * Execute the request
	 * @param RequestorContract $requestor
	 * @return ApiResponse
	 */
	public function execute(RequestorContract $requestor);
}
