<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'SureCart_Hook_Order_Range' ) ) :
	class SureCart_Hook_Order_Range extends myCRED_Hook {

		/**
		 * Construct
		 */
		function __construct( $hook_prefs, $type = MYCRED_DEFAULT_TYPE_KEY ) {

			parent::__construct( array(
				'id'       => 'surecart_order_range',
				'defaults' => array(
					'min' 	  => 1,
					'max' 	  => 100,
					'creds'   => 10,
					'log'     => '%plural% for order range'
				)
			), $hook_prefs, $type );

		}

		/**
		 * Run
		 * @since 1.8
		 * @version 1.0
		 */
		public function run() {

			add_action( 'surecart/purchase_created', array( $this, 'mycred_surecart_order_range' ) , 100 , 1);
		}

		public function numberBetween($min, $value, $max) {
		    return ($min <= $value && $value <= $max);
		}

		/**
		 * Add points
		 * @since 1.0
		 * @version 1.0
		 */
		public function mycred_surecart_order_range( $purchase ) {

			$wp_user = $purchase->getWPUser();

		    // Bail if no user is found
		    if ( empty( $wp_user ) || ! isset( $wp_user->ID ) ) {
		        return;
		    }

		    $price_id = $purchase->price ?? null;

		    if ($price_id) {
		        $price = \SureCart\Models\Price::find($price_id);
		        $amount = $price->amount / 100; // Convert from cents to dollars
		    }

		    if (  ! $this->numberBetween( $this->prefs['min'], $amount , $this->prefs['max'] ) ) {
		    	return;
		    } 
		   
		    // Extract user ID
		    $user_id = $wp_user->ID;

		    $product_id = $purchase->product  ?? null;
		    $quantity = $purchase->quantity ?? 1;
		    $customer = $purchase->customer ?? null;
		    $order_id = $purchase->initial_order ?? null;
		    $data      = array( 'ref_type' => 'post' );
		    $prefs = $this->prefs;

		    // Prevent duplicate rewards for the same order
		    if ( $this->core->has_entry( 'surecart_order_range', $order_id, $user_id, $data, $this->mycred_type ) ) {
		        return;
		    }

		    $this->core->add_creds(
		        'surecart_order_range',       
		        $user_id,                     
		        $this->prefs['creds'], 
		        $this->prefs['log'],   
		        $order_id,     
		        array( 'ref_type' => 'post' ),
		        $this->mycred_type         
		    );

			
		}

		/**
		 * Preference for Anniversary Hook
		 * @since 1.8
		 * @version 1.0
		 */
		public function preferences() {

			$prefs = $this->prefs;

			?>
			
			<div class="hook-instance">
				<div class="row">
					<div class="col-lg-7 col-md-7 col-sm-12 col-xs-12">
						<div class="row">
							<div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
								<div class="form-group">
									<label for="<?php echo esc_attr( $this->field_id( 'min' ) ); ?>"><?php echo esc_html( 'Minimum' ); ?></label>
									<input type="number" name="<?php echo esc_attr( $this->field_name( 'min' ) ); ?>" id="<?php echo esc_attr( $this->field_id( 'min' ) ); ?>" min="0" value="<?php echo esc_attr( $this->core->number( $prefs['min'] ) ); ?>" class="form-control" />
								</div>
							</div>
							<div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
								<div class="form-group">
									<label for="<?php echo esc_attr( $this->field_id( 'max' ) ); ?>"><?php echo esc_html( 'Maximum' ); ?></label>
									<input type="number" name="<?php echo esc_attr( $this->field_name( 'max' ) ); ?>" id="<?php echo esc_attr( $this->field_id( 'max' ) ); ?>" min="0" value="<?php echo esc_attr( $this->core->number( $prefs['max'] ) ); ?>" class="form-control" />
								</div>
							</div>
							<div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
								<div class="form-group">
									<label for="<?php echo esc_attr( $this->field_id( 'creds' ) ); ?>"><?php echo esc_html( $this->core->plural() ); ?></label>
									<input type="number" name="<?php echo esc_attr( $this->field_name( 'creds' ) ); ?>" id="<?php echo esc_attr( $this->field_id( 'creds' ) ); ?>" min="0" value="<?php echo esc_attr( $this->core->number( $prefs['creds'] ) ); ?>" class="form-control" />
								</div>
							</div>
						</div>
					</div>
					<div class="col-lg-5 col-md-5 col-sm-12 col-xs-12">
						<div class="form-group">
							<label for="<?php echo esc_attr( $this->field_id( 'log' ) ); ?>"><?php esc_html_e( 'Log Template', 'mycred' ); ?></label>
							<input type="text" name="<?php echo esc_attr( $this->field_name( 'log' ) ); ?>" id="<?php echo esc_attr( $this->field_id( 'log' ) ); ?>" placeholder="<?php esc_attr_e( 'required', 'mycred' ); ?>" value="<?php echo esc_attr( $prefs['log'] ); ?>" class="form-control" />
							<span class="description"><?php echo wp_kses_post( $this->available_template_tags( array( 'general' ) ) ); ?></span>
						</div>
					</div>
				</div>
			</div>
			<?php
		}

	  	/**
	     * Sanitize Preferences
	     */
		public function sanitise_preferences( $data ) {

			$new_data = array();

			$new_data['creds'] = ! empty( $data['creds'] ) ? (float)$data['creds'] : 0;
			$new_data['min'] = ! empty( $data['min'] ) ? abs( (int)$data['min'] ) : 0;
			$new_data['max'] = ! empty( $data['max'] ) ? ( abs( (int)$data['max'] ) < abs( (int)$data['min'] ) ? abs( (int)$data['min'] ) : abs( (int)$data['max'] ) ) : 0;
			$new_data['log'] = ! empty( $data['log'] ) ? wp_kses_post( $data['log'] ) : '%plural% for number of order';
			
			return $new_data;
		}

	}
endif;