<?php

require_once __DIR__ . '/client/GitHubClient.php';

$repos = array(
	'server',
	'installer',
);

$client = new GitHubClient();

foreach ($repos as $repo) {
	$client->setPage();
	$client->setPageSize(2);
	$commits = $client->repos->commits->listCommitsOnRepository('kaltura', $repo);

	echo 'Count: ' . esc_html(count($commits)) . "\n";
	foreach ($commits as $commit) {
		/* @var $commit GitHubCommit */
		echo esc_html(get_class($commit)) . ' - Sha: ' . esc_html($commit->getSha()) . "\n";
	}

	$commits = $client->getNextPage();

	echo 'Count: ' . esc_html(count($commits)) . "\n";
	foreach ($commits as $commit) {
		/* @var $commit GitHubCommit */
		echo esc_html(get_class($commit)) . ' - Sha: ' . esc_html($commit->getSha()) . "\n";
	}
}
